require("stategraphs/commonstates")

local actionhandlers =
{    
   ActionHandler(ACTIONS.EAT, "eat"),
	ActionHandler(ACTIONS.CHOP, "chop"),
	ActionHandler(ACTIONS.MINE, "mine"),
	ActionHandler(ACTIONS.DIG, "dig"),
	ActionHandler(ACTIONS.HAMMER, "hammer"),
	-- ActionHandler(ACTIONS.HACK, "hack"),
	
}

local events =
{
   CommonHandlers.OnStep(),
	CommonHandlers.OnLocomote(true, false),
	CommonHandlers.OnDeath(),
	EventHandler("attacked", function(inst)
		if not inst.components.health:IsDead() and not inst.sg:HasStateTag("attack") then
			inst.sg:GoToState("hit")
		end
	end),
	EventHandler("doattack", function(inst)
		if not inst.components.health:IsDead() then
			inst.sg:GoToState("attack")
		end
	end),
	EventHandler("doaction", function(inst, data) 
		if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
			if data.action == ACTIONS.CHOP then
				inst.sg:GoToState("chop_start", data.target)
			end
		end
	end),
	EventHandler("doaction", function(inst, data) 
		if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
			if data.action == ACTIONS.MINE then
				inst.sg:GoToState("mine_start", data.target)
			end
		end
	end),
	EventHandler("doaction", function(inst, data) 
		if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
			if data.action == ACTIONS.DIG then
				inst.sg:GoToState("dig_start", data.target)
			end
		end
	end),

	EventHandler("doaction", function(inst, data) 
		if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
			if data.action == ACTIONS.HAMMER then
				inst.sg:GoToState("hammer_start", data.target)
			end
		end
	end),
	
	-- EventHandler("doaction", function(inst, data) 
		-- if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then
			-- if data.action == ACTIONS.HACK then
				-- inst.sg:GoToState("hack_start", data.target)
			-- end
		-- end
	-- end),
		
	EventHandler("hide", function(inst)
        if not inst.sg:HasStateTag("hiding") then
            inst.sg:GoToState("hide")
        end
    end),



}

local states = {
	State {
		name= "idle",
		tags = {"idle"},
		onenter = function(inst)
			inst.Physics:Stop()
		end,
		events = {
			EventHandler("animover", function(inst)
				inst.sg:GoToState("idle")
			end)
		}     
	},
    State {
		name = "death",
		tags = {"busy"},
		onenter = function(inst)
			inst.SoundEmitter:PlaySound("dontstarve/characters/duty/death_voice") 
			inst.AnimState:PlayAnimation("death")
			inst.Physics:Stop()
			RemovePhysicsColliders(inst)      
			inst.components.lootdropper:DropLoot(Vector3(inst.Transform:GetWorldPosition())) 
		end
    },
	State {
		name = "run_start",
		tags = {"moving", "running", "canrotate"},
		onenter = function(inst)
			inst.components.locomotor:RunForward()
			inst.AnimState:PlayAnimation("run_pre")
			inst.sg.mem.foosteps = 0
		end,
		events = {   
			EventHandler("animover", function(inst)
				inst.sg:GoToState("run")
			end)       
		},
		timeline = {
			TimeEvent(4*FRAMES, function(inst)
				PlayFootstep(inst)
				DoFoleySounds(inst)
			end)
		}
	},
    State {
		name = "run",
		tags = {"moving", "running", "canrotate"},
		onenter = function(inst) 
			inst.components.locomotor:RunForward()
			inst.AnimState:PlayAnimation("run_loop")
		end,
		timeline = {
			TimeEvent(7*FRAMES, function(inst)
				inst.sg.mem.foosteps = inst.sg.mem.foosteps + 1
				PlayFootstep(inst, inst.sg.mem.foosteps < 5 and 1 or .6)
				DoFoleySounds(inst)
			end),
			TimeEvent(15*FRAMES, function(inst)
				inst.sg.mem.foosteps = inst.sg.mem.foosteps + 1
				PlayFootstep(inst, inst.sg.mem.foosteps < 5 and 1 or .6)
				DoFoleySounds(inst)
			end)
		},
		events = {   
			EventHandler("animover", function(inst)
				inst.sg:GoToState("run")
			end)  
		}
	},
	State {
		name = "run_stop",
		tags = {"canrotate", "idle"},
		onenter = function(inst) 
			inst.Physics:Stop()
			inst.AnimState:PlayAnimation("run_pst")
		end,
		events = {   
			EventHandler("animover", function(inst) 
				inst.sg:GoToState("idle") 
			end),        
		},
	},
	State {
		name = "attack",
		tags = {"attack"},
		onenter = function(inst)
			--inst.SoundEmitter:PlaySound("dontstarve/wilson/hit")
			inst.components.combat:StartAttack()
			inst.Physics:Stop()
			inst.AnimState:PlayAnimation("atk")
		inst:DoTaskInTime(1, function (inst) inst.components.inventory:Equip( inst.weapon ) end )
		end,
		timeline = {
			TimeEvent(13*FRAMES, function(inst) 
				inst.components.combat:DoAttack() 
			end),
		},
		events = {
			EventHandler("animover", function(inst) 
				inst.sg:GoToState("idle") 
			end),
		},
	},
	
	
	 State{
        name = "chop_start",
        tags = {"prechop", "working"},

        onenter = function(inst)
            local buffaction = inst:GetBufferedAction()
            inst.sg.statemem.target = buffaction ~= nil and buffaction.target or nil
			inst.equipfn(inst, inst.items["AXE"])
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("chop_pre")
        end,

        events =
        {
            EventHandler("animover", function(inst)
                if inst.AnimState:AnimDone() then
                    inst.sg:GoToState("chop")
                end
            end),
        },
    },

    State{
        name = "chop",
        tags = {"prechop", "chopping", "working"},

        onenter = function(inst)
            local buffaction = inst:GetBufferedAction()
            inst.sg.statemem.target = buffaction ~= nil and buffaction.target or nil

            inst.AnimState:PlayAnimation("chop_loop")
        end,

        timeline =
        {
            TimeEvent(2 * FRAMES, function(inst)
                inst:PerformBufferedAction()
            end),

            TimeEvent(13 * FRAMES, function(inst)
                inst.sg:RemoveStateTag("prechop")
            end),

            TimeEvent(16*FRAMES, function(inst)
                inst.sg:RemoveStateTag("chopping")
            end),
        },

        events =
        {
            EventHandler("animover", function(inst)
                if inst.AnimState:AnimDone() then
                    inst.sg:GoToState("idle")
                end
            end),
        },
    },

	-- State {
		-- name = "chop",
		-- tags = {"chopping"},
		-- onenter = function(inst)
			-- inst.Physics:Stop()
			-- inst.AnimState:PlayAnimation("atk")
			-- inst.components.combat:StartAttack()
		-- end,
		-- timeline = {
			-- TimeEvent(13*FRAMES, function(inst) 
				-- inst:PerformBufferedAction() 
			-- end),
		-- },
		-- events = {
			-- EventHandler("animover", function(inst) 
				-- inst.sg:GoToState("idle") 
			-- end),
		-- },
	-- },
    State{ 
        name = "mine_start",
        tags = {"premine", "working"},
        onenter = function(inst)
            inst.equipfn(inst, inst.items["PICK"])
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("pickaxe_pre")
        end,
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("mine") end),
        },
    },   
    State{
        name = "mine",
        tags = {"premine", "mining", "working"},
        onenter = function(inst)
            inst.AnimState:PlayAnimation("pickaxe_loop")
        end,

        timeline=
        {
            TimeEvent(9*FRAMES, function(inst) 
                inst:PerformBufferedAction() 
                inst.sg:RemoveStateTag("premine") 
                inst.SoundEmitter:PlaySound("dontstarve/wilson/use_pick_rock")
            end),
		},
        events=
        {
            EventHandler("animover", function(inst) 
                inst.AnimState:PlayAnimation("pickaxe_pst") 
                inst.sg:GoToState("idle", true)
            end ),            
        },        
    },
	
	State{
        name = "dig_start",
        tags = {"predig", "working"},

        onenter = function(inst)
            local buffaction = inst:GetBufferedAction()
            inst.sg.statemem.target = buffaction ~= nil and buffaction.target or nil

            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("shovel_pre")
        end,

        events =
        {
            EventHandler("animover", function(inst)
                if inst.AnimState:AnimDone() then
                    inst.sg:GoToState("dig")
                end
            end),
        },
    },

    State{
        name = "dig",
        tags = {"predig", "digging", "working"},

        onenter = function(inst)
            local buffaction = inst:GetBufferedAction()
            inst.sg.statemem.target = buffaction ~= nil and buffaction.target or nil

            inst.AnimState:PlayAnimation("shovel_loop")
        end,

        timeline =
        {
            TimeEvent(15 * FRAMES, function(inst)
                inst:PerformBufferedAction()
                inst.SoundEmitter:PlaySound("dontstarve/wilson/dig")
            end),

            TimeEvent(35 * FRAMES, function(inst)
                inst.sg:RemoveStateTag("predig")
            end),
        },

        events =
        {
            EventHandler("animover", function(inst)
                if inst.AnimState:AnimDone() then
                    inst.AnimState:PlayAnimation("shovel_pst")
                    inst.sg:GoToState("idle", true)
                end
            end),
        },
    },
	
	State{
        name = "hammer_start",
        tags = { "prehammer", "working" },

        onenter = function(inst)
            inst.components.locomotor:Stop()
            inst.AnimState:PlayAnimation("pickaxe_pre")
        end,

        events =
        {
            EventHandler("unequip", function(inst) inst.sg:GoToState("idle") end),
            EventHandler("animover", function(inst)
                if inst.AnimState:AnimDone() then
                    inst.sg:GoToState("hammer")
                end
            end),
        },
    },

    State{
        name = "hammer",
        tags = { "prehammer", "hammering", "working" },

        onenter = function(inst)
            inst.sg.statemem.action = inst:GetBufferedAction()
            inst.AnimState:PlayAnimation("pickaxe_loop")
        end,

        timeline =
        {
            TimeEvent(7 * FRAMES, function(inst)
                inst:PerformBufferedAction()
                inst.sg:RemoveStateTag("prehammer")
                inst.SoundEmitter:PlaySound("dontstarve/wilson/hit")
            end),

            TimeEvent(9 * FRAMES, function(inst)
                inst.sg:RemoveStateTag("prehammer")
            end),

            
        },

        events =
        {
            EventHandler("unequip", function(inst) inst.sg:GoToState("idle") end),
            EventHandler("animover", function(inst)
                if inst.AnimState:AnimDone() then
                    inst.AnimState:PlayAnimation("pickaxe_pst")
                    inst.sg:GoToState("idle", true)
                end
            end),
        },
    },
	
	State {
		name = "eat",
		tags = {"busy"},
		onenter = function(inst)
			inst.Physics:Stop()            
			inst.AnimState:PlayAnimation("eat")
		end,
		events = {
			EventHandler("animover", function(inst) 
				inst.sg:GoToState("idle") 
			end),
		},
	},
	
	State {
		name = "hit",
		tags = {"busy"},
		onenter = function(inst)
			inst:InterruptBufferedAction()
			inst.SoundEmitter:PlaySound("dontstarve/characters/duty/hurt")        
			inst.AnimState:PlayAnimation("hit")    
			inst.Physics:Stop()            
		end,
		events = {
			EventHandler("animover", function(inst) 
				inst.sg:GoToState("idle") 
			end),
		},
		timeline = {
			TimeEvent(3*FRAMES, function(inst)
				inst.sg:RemoveStateTag("busy")
			end),
		},
	},
	
	
	State{
        name = "hide",
		tags = {"hiding", "notalking", "notarget", "nomorph", "busy", "nopredict", "nodangle"},
		
        onenter = function(inst)
            inst.components.locomotor:Stop()
            inst.AnimState:PushAnimation("hide_idle", false)
			inst.sg:AddStateTag("hide")
        end,
		
		timeline =
        {
            TimeEvent(24 * FRAMES, function(inst)
                inst.sg:RemoveStateTag("busy")
                inst.sg:RemoveStateTag("nopredict")
                inst.sg:AddStateTag("idle")
				inst:Hide()
				inst.DynamicShadow:Enable(false)
            end),
        },
		onexit = function(inst)
        inst:Show()
		inst.DynamicShadow:Enable(true)
		if inst.components.health then
			inst.components.health:SetInvincible(false)
		end
		
		end,
		-- events=
        -- {
			-- EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        -- },
    },
	
	-- State{ name = "hack_start",
        -- tags = {"prehack", "hacking", "working"},
        -- onenter = function(inst)
            -- inst.components.locomotor:Stop()
            -- inst.AnimState:PlayAnimation("chop_pre")
        -- end,
        
        -- events=
        -- {
            -- EventHandler("unequip", function(inst) inst.sg:GoToState("idle") end ),
            -- EventHandler("animover", function(inst) inst.sg:GoToState("hack") end),
        -- },
    -- },
    
    -- State{
        -- name = "hack",
        -- tags = {"prehack", "hacking", "working"},
        -- onenter = function(inst)
            -- inst.sg.statemem.action = inst:GetBufferedAction()
            -- inst.AnimState:PlayAnimation("chop_loop")            
        -- end,
        
        -- timeline=
        -- {
                       
            -- TimeEvent(5*FRAMES, function(inst) 
                -- inst:PerformBufferedAction() 
            -- end),


            -- TimeEvent(9*FRAMES, function(inst)
                -- inst.sg:RemoveStateTag("prehack")
            -- end),
            

            -- TimeEvent(16*FRAMES, function(inst) 
                -- inst.sg:RemoveStateTag("hacking")
            -- end),

        -- },
        
        -- events=
        -- {
            -- EventHandler("unequip", function(inst) inst.sg:GoToState("idle") end ),
            -- EventHandler("animover", function(inst) 
                --inst.AnimState:PlayAnimation("chop_pst") 
                -- inst.sg:GoToState("idle")
            -- end ),
            
        -- },        
    -- },
	
	-- State{
        -- name = "doh",
		-- tags = {"busy", "knockout", "nopredict", "nomorph"},
		
        -- onenter = function(inst)
            -- inst.components.locomotor:Stop()
            -- inst:ClearBufferedAction()
            -- if inst.AnimState:IsCurrentAnimation("run_pst") then
                -- inst.AnimState:PushAnimation("emoteXL_facepalm")
            -- else
               -- inst.AnimState:PushAnimation("emoteXL_facepalm")
            -- end
            -- inst.AnimState:PushAnimation("emoteXL_facepalm", false)
        -- end,
		-- events=
        -- {
			-- EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        -- },
    -- },
	
	-- State{
        -- name = "wave",
		-- tags = {"giving"},
		
        -- onenter = function(inst)
            -- inst.components.locomotor:Stop()
            -- inst:ClearBufferedAction()
            -- if inst.AnimState:IsCurrentAnimation("run_pst") then
                -- inst.AnimState:PushAnimation("emoteXL_waving1")
            -- else
               -- inst.AnimState:PushAnimation("emoteXL_waving1")
            -- end
            -- inst.AnimState:PushAnimation("emoteXL_waving1", false)
        -- end,
		-- events=
        -- {
			-- EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        -- },
    -- },

		
}


CommonStates.AddWalkStates(states, {
	walktimeline = {
		TimeEvent(0*FRAMES, PlayFootstep),
		TimeEvent(12*FRAMES, PlayFootstep),
	},
})

CommonStates.AddRunStates(states, {
	runtimeline = {
		TimeEvent(0*FRAMES, PlayFootstep),
		TimeEvent(10*FRAMES, PlayFootstep),
	},
})


return StateGraph("dutyexoai", states, events, "idle", actionhandlers)
